/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.teastory.data.recipe.builder;

import cloud.lemonslice.teastory.recipe.drink.DrinkRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.TeaStory;
import xueluoanping.teastory.craft.FluidIngredient;
import xueluoanping.teastory.registry.FluidRegistry;
import xueluoanping.teastory.registry.RecipeRegister;

public class DrinkRecipeBuilder {
    private final Fluid result;
    private final FluidIngredient fluidIngredient;
    private final NonNullList<Ingredient> ingredients;

    private DrinkRecipeBuilder(Fluid resultIn, FluidIngredient fluidIngredientIn, NonNullList<Ingredient> ingredientsIn) {
        this.result = resultIn;
        this.fluidIngredient = fluidIngredientIn;
        this.ingredients = ingredientsIn;
    }

    public static DrinkRecipeBuilder drinkRecipe(Fluid resultIn, FluidIngredient fluidIngredientIn, Ingredient ... ingredientsIn) {
        return new DrinkRecipeBuilder(resultIn, fluidIngredientIn, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredientsIn));
    }

    public static DrinkRecipeBuilder boilingRecipe(Fluid resultIn, Ingredient ... ingredientsIn) {
        return new DrinkRecipeBuilder(resultIn, FluidIngredient.fromFluid((Fluid)FluidRegistry.BOILING_WATER_STILL.get(), 500), (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredientsIn));
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.FLUIDS.getKey((Object)this.result));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation originRes = ForgeRegistries.FLUIDS.getKey((Object)this.result);
        ResourceLocation saveRes = ResourceLocation.m_135820_((String)save);
        if (saveRes.equals((Object)originRes)) {
            throw new IllegalStateException("Recipe " + saveRes + " should remove its 'save' argument");
        }
        this.build(consumerIn, saveRes);
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.result, this.fluidIngredient, this.ingredients));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final FluidIngredient fluidIngredient;
        private final NonNullList<Ingredient> ingredients;
        private final Fluid result;
        private final RecipeSerializer<DrinkRecipe> serializer = (RecipeSerializer)RecipeRegister.DRINK_MAKER_SERIALIZER.get();

        public Result(ResourceLocation idIn, Fluid resultIn, FluidIngredient fluidIngredientIn, NonNullList<Ingredient> ingredientsIn) {
            this.id = TeaStory.rl(idIn.m_135827_(), "drink_maker/" + idIn.m_135815_());
            this.fluidIngredient = fluidIngredientIn;
            this.result = resultIn;
            this.ingredients = ingredientsIn;
        }

        public void m_7917_(JsonObject json) {
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.m_43942_());
            }
            json.add("item_ingredients", (JsonElement)jsonarray);
            json.add("fluid_ingredient", (JsonElement)this.fluidIngredient.serialize());
            json.addProperty("drink_result", ForgeRegistries.FLUIDS.getKey((Object)this.result).toString());
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

